<?php
/**
 * @file  multiotp.api.demo.php
 * @brief Demo using the tools to call multiOTP Enterprise Web API commands
 *
 * multiOTP API tools demo
 *
 * PHP 5.4.0 or higher is supported.
 *
 * @author    Andre Liechti, SysCo systemes de communication sa, <support@multiotp.com>
 * @version   5.9.6.7
 * @date      2023-09-22
 * @since     2013-02-10
 * @copyright (c) 2010-2023 SysCo systemes de communication sa
 * @copyright GNU Lesser General Public License
 *********************************************************************/

require_once("multiotp.api.tools.php");

set_time_limit(300);

if ("cli" == php_sapi_name()) {
  $br = "\n====================\n";
  $crlf = "\n";
  $precode_on = "";
  $precode_off = "";
} else {
  $br = "<hr />\n";
  $crlf = "<br />\n";
  $precode_on = "<pre><code>";
  $precode_off = "</pre></code>";
}


// Set the device IP and the shared secret access.
// On the multiOTP Enterprise server side, a specific device must be created,
// with the same shared secret, the source IP, and with the
// option "This device can use API calls" activated
$device = "your.multiotp.server.ip";
$secret = "secret";


///////////////////////////////////////////////////////////////////////////////
// Get appliance memory information
$command = "GetLockedAccountsList";
$result = CallApi(array(
  "secret"     => $secret,
  "script_uri" => "https://$device/?".
    "Command=$command".
    ""
));

echo "$precode_on$command\n".nice_json($result, "  ")."$precode_off" . $br;
flush();
@ob_flush();


///////////////////////////////////////////////////////////////////////////////
// Get accounts list
$command = "GetAccountsList";
$result = CallApi(array(
  "secret"     => $secret,
  "script_uri" => "https://$device/?".
    "Command=$command".
    ""
));

$array_result = json_decode($result, true);

if (isset($array_result["result"])) {

  ///////////////////////////////////////////////////////////////////////////////
  // Loop for each account
  foreach ($array_result["result"] as $one_result) {

    echo "Generate PDF file for user " . $one_result["account"] . $crlf;

    ///////////////////////////////////////////////////////////////////////////////
    // Get the provisioning PDF file for an account, and write it into "account".pdf
    $file = $one_result["account"] . ".pdf";

    $command = "GetAccountProvisioningPdf";
    $account = $one_result["account"];
    $result = CallApi(array(
      "secret"     => $secret,
      "script_uri" => "http://$device/?".
        "Command=$command".
        "&".
        "Account=$account".
        ""
    ));

    file_put_contents($file, $result);
  }
}

echo $br;

exit();
